#install.packages("Synth")

library(Synth)

rm(list = ls())


dat = read.csv("synthetic.csv")
dat$ctyname = as.character(dat$ctyname)

dat.treated = dat[dat$treated==1,]
treated.w2 = colMeans(dat.treated[dat.treated$wave==2,3:which(colnames(dat)=="logpop")], na.rm=T)
treated.w3 = colMeans(dat.treated[dat.treated$wave==3,3:which(colnames(dat)=="logpop")], na.rm=T)


## add composite treated cases
dat = rbind(dat,
            c(2, NA, treated.w2, 1, 100),
            c(3, NA, treated.w3, 1, 100)
            )

dat[c(19,20), 2] = "All Treated"


##########################################################

build.data <- function(predictors, treatment.identifier, controls.identifier) {
  
  return(
    dataprep(
      foo = dat,
      predictors = predictors,
      predictors.op = "mean",
      dependent = "irtsupport",
      unit.variable = "country",
      time.variable = "wave",
      treatment.identifier = treatment.identifier,
      controls.identifier = controls.identifier,
      time.predictors.prior = 2,
      time.optimize.ssr = 2,
      unit.names.variable = "ctyname",
      time.plot = 2:3
    )
  )
}

individual = which(colnames(dat) %in% c("sharia", "religious", "trust", "membership", "income1k", "education",
                  "protest", "econperformance", "demoseffective2", "female", "age", "working",
                  "gdppc", "gdpgrowth", "unemployment", "logpop"))
ctylevel = which(colnames(dat) %in% c("gdppc", "gdpgrowth", "unemployment", "logpop"))      
  


# All Treated -- all controls -- country-level vars except polity
dataprep.out <- build.data(ctylevel, 100, c(1,7,8,10,15,19))
synth.out <- synth(dataprep.out)
png("Figure3.png", height=727, width=1000)
path.plot(dataprep.res = dataprep.out,synth.res = synth.out, 
          Ylim=c(min(dat$irtsupport), max(dat$irtsupport)),
          Ylab=c("Support for Democracy"),
          Xlab=c("Wave"))
dev.off()
#gaps.plot(dataprep.res = dataprep.out,synth.res = synth.out)

synth.tables <- synth.tab(
  dataprep.res = dataprep.out,
  synth.res = synth.out)
print(synth.tables)


